# 如果想使用openjtalk提取音素的功能，请使用以下函数

```c++
// 创建Ojt实例，folder需要输入字典的路径（文件夹）
void CreateOjt(const wchar_t* folder);   
// 提取音素（返回值为提取好的罗马字以及对应信息，"换行符"为下一个音素的标记
const wchar_t* extractFullContext(const wchar_t*);
// 提取片假名
const wchar_t* getKana(const wchar_t*);
// 提取罗马字
const wchar_t* getPhoneme(const wchar_t*);
// 提取罗马字
const wchar_t* getRomaji(const wchar_t*);
// 部分提取国际音标
const wchar_t* getIpa1(const wchar_t*);
// 部分提取国际音标
const wchar_t* getIpa2(const wchar_t*);
// 提取罗马字（假名间空格，拔音前不空格）
const wchar_t* getPhonemeWithBlank(const wchar_t*);
// 提取罗马字（假名间空格，拔音前不空格）
const wchar_t* getRomajiWithBlank(const wchar_t*);
// 部分提取国际音标（假名间空格，拔音前不空格）
const wchar_t* getIpa1WithBlank(const wchar_t*);
// 部分提取国际音标（假名间空格，拔音前不空格）
const wchar_t* getIpa2WithBlank(const wchar_t*);
// 释放Ojt实例
void Release();
```

# 示例程序

```c++
/*-----------------------------C++示例程序-----------------------------*/
#include <iostream>
#include <windows.h>
#include <string>

int main()
{
	// 将wcout的输出地区定为中国
	std::wcout.imbue(std::locale("chs"));
	
	// 函数指针类型（与上文函数对应）
	using funTy = const wchar_t* (*)(const wchar_t*); 
	
	// 使用WinApi载入Dll
	const auto m_hDynLib = LoadLibrary(L"JapaneseCleaner.dll");
	
	// 载入失败返回0
	if (!m_hDynLib) 
		return 0;
		
	// 载入需要的函数
	const auto CreateOjt = reinterpret_cast<void (*)(const wchar_t*)>(
		reinterpret_cast<void*>(
			GetProcAddress(m_hDynLib, "CreateOjt")
			)
		);
	const auto Test = reinterpret_cast<funTy>(
		reinterpret_cast<void*>(
			GetProcAddress(m_hDynLib, "getRomajiWithBlank")
			)
		);
		
	// 载入失败返回0
	if(!CreateOjt) 
		return 0;
	
	// 创建Ojt实例
	CreateOjt("替换为你的字典路径"); 
	
	// 转换（返回值为空时为转换失败，也许是内存不够或是未调用CreateOjt创建Ojt实例）
	const wchar_t* tmp = Test("授業中に出したら、学生生活終わるなり"); 
	
	// 转换失败则返回0
	if(!tmp)
		return 0;
	
	// 转换为wstring防止未知的编码问题
	const std::wstring a = tmp;        
	
	//输出结果
	std::wcout << a;
	
	// 释放动态库
	FreeLibrary(m_hDynLib);
}
```



by NaruseMioShirakana 

仓库地址：https://github.com/NaruseMioShirakana/JapaneseCleaner